
package mage.cards.w;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.PlayWithTheTopCardRevealedEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author LoneFox
 */
public final class WizenedSnitches extends CardImpl {

    public WizenedSnitches(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{U}");
        this.subtype.add(SubType.FAERIE);
        this.subtype.add(SubType.ROGUE);
        this.power = new MageInt(1);
        this.toughness = new MageInt(3);

        // Flying
        this.addAbility(FlyingAbility.getInstance());
        // Players play with the top card of their libraries revealed.
        this.addAbility(new SimpleStaticAbility(new PlayWithTheTopCardRevealedEffect(true)));
    }

    private WizenedSnitches(final WizenedSnitches card) {
        super(card);
    }

    @Override
    public WizenedSnitches copy() {
        return new WizenedSnitches(this);
    }
}
