
package mage.cards.w;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.counter.GetEnergyCountersControllerEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.permanent.token.ThopterColorlessToken;

/**
 *
 * @author emerald000
 */
public final class WhirlerVirtuoso extends CardImpl {

    public WhirlerVirtuoso(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{U}{R}");
        this.subtype.add(SubType.VEDALKEN);
        this.subtype.add(SubType.ARTIFICER);
        this.power = new MageInt(2);
        this.toughness = new MageInt(3);

        // When Whirler Virtuoso enters the battlefield, you get {E}{E}{E}.
        this.addAbility(new EntersBattlefieldTriggeredAbility(new GetEnergyCountersControllerEffect(3)));

        // Pay {E}{E}{E}: Create a 1/1 colorless Thopter artifact creature token with flying.
        this.addAbility(new SimpleActivatedAbility(new CreateTokenEffect(new ThopterColorlessToken()), new PayEnergyCost(3)));
    }

    private WhirlerVirtuoso(final WhirlerVirtuoso card) {
        super(card);
    }

    @Override
    public WhirlerVirtuoso copy() {
        return new WhirlerVirtuoso(this);
    }
}
