
package mage.cards.w;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.constants.Zone;

/**
 *
 * @author fireshoes
 */
public final class WelderAutomaton extends CardImpl {

    public WelderAutomaton(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}, "{2}");

        this.subtype.add(SubType.CONSTRUCT);
        this.power = new MageInt(2);
        this.toughness = new MageInt(1);

        // {3}{R}: Welder Automaton deals 1 damage to each opponent.
        this.addAbility(new SimpleActivatedAbility(new DamagePlayersEffect(1, TargetController.OPPONENT), new ManaCostsImpl<>("{3}{R}")));
    }

    private WelderAutomaton(final WelderAutomaton card) {
        super(card);
    }

    @Override
    public WelderAutomaton copy() {
        return new WelderAutomaton(this);
    }
}
