
package mage.cards.w;

import java.util.UUID;
import mage.abilities.common.AsEntersBattlefieldAbility;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.common.TapSourceUnlessPaysEffect;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;

/**
 *
 * @author BetaSteward_at_googlemail.com
 */
public final class WateryGrave extends CardImpl {

    public WateryGrave(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.LAND}, null);
        this.subtype.add(SubType.ISLAND);
        this.subtype.add(SubType.SWAMP);

        this.addAbility(new AsEntersBattlefieldAbility(new TapSourceUnlessPaysEffect(new PayLifeCost(2)), "you may pay 2 life. If you don't, it enters tapped"));
        this.addAbility(new BlueManaAbility());
        this.addAbility(new BlackManaAbility());
    }

    private WateryGrave(final WateryGrave card) {
        super(card);
    }

    @Override
    public WateryGrave copy() {
        return new WateryGrave(this);
    }

}
