
package mage.cards.w;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.keyword.DefenderAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.target.common.TargetControlledPermanent;

/**
 *
 * @author LevelX2
 */
public final class WallOfMulch extends CardImpl {

    private static final FilterControlledPermanent filter = new FilterControlledPermanent("a Wall");
    
    static {
        filter.add(SubType.WALL.getPredicate());
    }
    
       
    
    public WallOfMulch(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{G}");
        this.subtype.add(SubType.WALL);

        this.power = new MageInt(0);
        this.toughness = new MageInt(4);

        // Defender
        this.addAbility(DefenderAbility.getInstance());
        // {G}, Sacrifice a Wall: Draw a card.
        Ability ability = new SimpleActivatedAbility(new DrawCardSourceControllerEffect(1), new ManaCostsImpl<>("{G}"));
        ability.addCost(new SacrificeTargetCost(filter));
        this.addAbility(ability);
        
    }

    private WallOfMulch(final WallOfMulch card) {
        super(card);
    }

    @Override
    public WallOfMulch copy() {
        return new WallOfMulch(this);
    }
}
