
package mage.cards.w;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.combat.CanBlockAdditionalCreatureEffect;
import mage.abilities.keyword.DefenderAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author fireshoes
 */
public final class WallOfGlare extends CardImpl {

    public WallOfGlare(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{W}");
        this.subtype.add(SubType.WALL);
        this.power = new MageInt(0);
        this.toughness = new MageInt(5);

        // Defender
        this.addAbility(DefenderAbility.getInstance());
        
        // Wall of Glare can block any number of creatures.
        this.addAbility(new SimpleStaticAbility(new CanBlockAdditionalCreatureEffect(0)));
    }

    private WallOfGlare(final WallOfGlare card) {
        super(card);
    }

    @Override
    public WallOfGlare copy() {
        return new WallOfGlare(this);
    }
}
