package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.CantActivateAbilitiesAttachedEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author LevelX2
 */
public final class VipersKiss extends CardImpl {

    public VipersKiss(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{B}");
        this.subtype.add(SubType.AURA);


        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.UnboostCreature));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);
        // Enchanted creature gets -1/-1 and its activated abilities can't be activated.
        ability = new SimpleStaticAbility(new BoostEnchantedEffect(-1,-1, Duration.WhileOnBattlefield));
        Effect effect = new CantActivateAbilitiesAttachedEffect();
        effect.setText(", and its activated abilities can't be activated");
        ability.addEffect(effect);
        this.addAbility(ability);

    }

    private VipersKiss(final VipersKiss card) {
        super(card);
    }

    @Override
    public VipersKiss copy() {
        return new VipersKiss(this);
    }
}
