
package mage.cards.v;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.StaticFilters;

/**
 *
 * @author KholdFuzion
 */
public final class VictualSliver extends CardImpl {

    public VictualSliver(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{G}{W}");
        this.subtype.add(SubType.SLIVER);

        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // All Slivers have "{2}, Sacrifice this permanent: You gain 4 life."
        Ability ability = new SimpleActivatedAbility(new GainLifeEffect(4), new SacrificeSourceCost());
        ability.addCost(new GenericManaCost(2));

        this.addAbility(new SimpleStaticAbility(
                new GainAbilityAllEffect(ability,
                        Duration.WhileOnBattlefield, StaticFilters.FILTER_PERMANENT_ALL_SLIVERS,
                        "All Slivers have \"{2}, Sacrifice this permanent: You gain 4 life.\"")));
    }

    private VictualSliver(final VictualSliver card) {
        super(card);
    }

    @Override
    public VictualSliver copy() {
        return new VictualSliver(this);
    }
}
