package mage.cards.v;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.SpellCastOpponentTriggeredAbility;
import mage.abilities.condition.common.SourceMatchesFilterCondition;
import mage.abilities.decorator.ConditionalInterveningIfTriggeredAbility;
import mage.abilities.effects.common.continuous.BecomesCreatureSourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterSpell;
import mage.filter.StaticFilters;
import mage.game.permanent.token.TokenImpl;

/**
 *
 * @author jeffwadsworth
 */
public final class VeilOfBirds extends CardImpl {

    private static final FilterSpell filter = new FilterSpell();

    public VeilOfBirds(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{U}");

        // When an opponent casts a spell, if Veil of Birds is an enchantment, Veil of Birds becomes a 1/1 Bird creature with flying.
        TriggeredAbility ability = new SpellCastOpponentTriggeredAbility(new BecomesCreatureSourceEffect(new VeilOfBirdsToken(), null, Duration.WhileOnBattlefield),
                filter, false);
        this.addAbility(new ConditionalInterveningIfTriggeredAbility(ability, new SourceMatchesFilterCondition(StaticFilters.FILTER_PERMANENT_ENCHANTMENT),
                "When an opponent casts a spell, if {this} is an enchantment, {this} becomes a 1/1 Bird creature with flying."));
    }

    private VeilOfBirds(final VeilOfBirds card) {
        super(card);
    }

    @Override
    public VeilOfBirds copy() {
        return new VeilOfBirds(this);
    }
}

class VeilOfBirdsToken extends TokenImpl {

    public VeilOfBirdsToken() {
        super("Bird", "1/1 creature with flying");
        cardType.add(CardType.CREATURE);
        subtype.add(SubType.BIRD);
        power = new MageInt(1);
        toughness = new MageInt(1);
        this.addAbility(FlyingAbility.getInstance());
    }

    private VeilOfBirdsToken(final VeilOfBirdsToken token) {
        super(token);
    }

    public VeilOfBirdsToken copy() {
        return new VeilOfBirdsToken(this);
    }
}
