package mage.cards.u;

import java.util.UUID;
import mage.constants.SubType;
import mage.target.common.TargetLandPermanent;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.constants.Outcome;
import mage.target.TargetPermanent;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.mana.AnyColorManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Zone;

/**
 *
 * @author TheElk801
 */
public final class UrbanUtopia extends CardImpl {

    public UrbanUtopia(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{G}");

        this.subtype.add(SubType.AURA);

        // Enchant Land
        TargetPermanent auraTarget = new TargetLandPermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.BoostCreature));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);

        // When Urban Utopia enters the battlefield, draw a card.
        this.addAbility(new EntersBattlefieldTriggeredAbility(
                new DrawCardSourceControllerEffect(1)
        ));

        // Enchanted land has "{T}: Add one mana of any color."
        this.addAbility(new SimpleStaticAbility(
                new GainAbilityAttachedEffect(
                        new AnyColorManaAbility(), AttachmentType.AURA
                ).setText("Enchanted land has "
                        + "\"{T}: Add one mana of any color.\"")
        ));
    }

    private UrbanUtopia(final UrbanUtopia card) {
        super(card);
    }

    @Override
    public UrbanUtopia copy() {
        return new UrbanUtopia(this);
    }
}
