
package mage.cards.u;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.ForestwalkAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author Quercitron
 */
public final class UnseenWalker extends CardImpl {

    public UnseenWalker(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{G}");
        this.subtype.add(SubType.DRYAD);

        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Forestwalk
        this.addAbility(new ForestwalkAbility());
         
        // {1}{G}{G}: Target creature gains forestwalk until end of turn.
        Ability ability = new SimpleActivatedAbility(
                new GainAbilityTargetEffect(new ForestwalkAbility(false), Duration.EndOfTurn), 
                new ManaCostsImpl<>("{1}{G}{G}"));
        ability.addTarget(new TargetCreaturePermanent());
        this.addAbility(ability);
    }

    private UnseenWalker(final UnseenWalker card) {
        super(card);
    }

    @Override
    public UnseenWalker copy() {
        return new UnseenWalker(this);
    }
}
