
package mage.cards.t;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.common.RegenerateSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author LoneFox
 */
public final class TunnelerWurm extends CardImpl {

    public TunnelerWurm(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{6}{G}{G}");
        this.subtype.add(SubType.WURM);
        this.power = new MageInt(6);
        this.toughness = new MageInt(6);

        // Discard a card: Regenerate Tunneler Wurm.
        this.addAbility(new SimpleActivatedAbility(new RegenerateSourceEffect(), new DiscardCardCost()));
    }

    private TunnelerWurm(final TunnelerWurm card) {
        super(card);
    }

    @Override
    public TunnelerWurm copy() {
        return new TunnelerWurm(this);
    }
}
