
package mage.cards.t;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.ShadowAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author fireshoes
 */
public final class TrespasserIlVec extends CardImpl {

    public TrespasserIlVec(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{B}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.ROGUE);
        this.power = new MageInt(3);
        this.toughness = new MageInt(1);

        // Discard a card: Trespasser il-Vec gains shadow until end of turn.
        this.addAbility(new SimpleActivatedAbility(
                new GainAbilitySourceEffect(ShadowAbility.getInstance(), Duration.EndOfTurn), 
                new DiscardCardCost()));
    }

    private TrespasserIlVec(final TrespasserIlVec card) {
        super(card);
    }

    @Override
    public TrespasserIlVec copy() {
        return new TrespasserIlVec(this);
    }
}
