
package mage.cards.t;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.target.common.TargetCardInHand;

/**
 *
 * @author cbt33
 */
public final class TirelessTribe extends CardImpl {

    public TirelessTribe(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{W}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.NOMAD);

        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Discard a card: Tireless Tribe gets +0/+4 until end of turn.
        this.addAbility(new SimpleActivatedAbility(new BoostSourceEffect(0, 4, Duration.EndOfTurn), new DiscardTargetCost(new TargetCardInHand())));
    }

    private TirelessTribe(final TirelessTribe card) {
        super(card);
    }

    @Override
    public TirelessTribe copy() {
        return new TirelessTribe(this);
    }
}
