
package mage.cards.t;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.MaximumHandSizeControllerEffect;
import mage.abilities.effects.common.continuous.MaximumHandSizeControllerEffect.HandSizeModification;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author LevelX2
 */
public final class ThoughtDevourer extends CardImpl {

    public ThoughtDevourer(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{U}{U}");
        this.subtype.add(SubType.BEAST);

        this.power = new MageInt(4);
        this.toughness = new MageInt(4);

        // Flying
        this.addAbility(FlyingAbility.getInstance());

        // Your maximum hand size is reduced by four.
        this.addAbility(new SimpleStaticAbility(
                new MaximumHandSizeControllerEffect(4, Duration.WhileOnBattlefield, HandSizeModification.REDUCE)));
    }

    private ThoughtDevourer(final ThoughtDevourer card) {
        super(card);
    }

    @Override
    public ThoughtDevourer copy() {
        return new ThoughtDevourer(this);
    }
}
