
package mage.cards.t;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.TapTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author FenrisulfrX
 */
public final class ThornscapeApprentice extends CardImpl {

    public ThornscapeApprentice(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{G}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.WIZARD);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // {R}, {tap}: Target creature gains first strike until end of turn.
        SimpleActivatedAbility ability1 = new SimpleActivatedAbility(
                new GainAbilityTargetEffect(FirstStrikeAbility.getInstance(), Duration.EndOfTurn),
                new ManaCostsImpl<>("{R}"));
        ability1.addCost(new TapSourceCost());
        ability1.addTarget(new TargetCreaturePermanent());
        this.addAbility(ability1);

        // {W}, {tap}: Tap target creature.
        SimpleActivatedAbility ability2 = new SimpleActivatedAbility(
                new TapTargetEffect(), new ManaCostsImpl<>("{W}"));
        ability2.addCost(new TapSourceCost());
        ability2.addTarget(new TargetCreaturePermanent());
        this.addAbility(ability2);
    }

    private ThornscapeApprentice(final ThornscapeApprentice card) {
        super(card);
    }

    @Override
    public ThornscapeApprentice copy() {
        return new ThornscapeApprentice(this);
    }
}
