
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.MayTapOrUntapTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author LevelX2
 */
public final class ThassasIre extends CardImpl {

    public ThassasIre(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{U}");


        // {3}{U}: You may tap or untap target creature.
        Ability ability = new SimpleActivatedAbility(new MayTapOrUntapTargetEffect(), new ManaCostsImpl<>("{3}{U}"));
        ability.addTarget(new TargetCreaturePermanent());
        this.addAbility(ability);
    }

    private ThassasIre(final ThassasIre card) {
        super(card);
    }

    @Override
    public ThassasIre copy() {
        return new ThassasIre(this);
    }
}
