
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.target.common.TargetPlayerOrPlaneswalker;

/**
 *
 * @author nigelzor
 */
public final class TelimTorsDarts extends CardImpl {

    public TelimTorsDarts(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{2}");

        // {2}, {tap}: Telim'Tor's Darts deals 1 damage to target player.
        Ability ability = new SimpleActivatedAbility(new DamageTargetEffect(1), new GenericManaCost(2));
        ability.addCost(new TapSourceCost());
        ability.addTarget(new TargetPlayerOrPlaneswalker());
        this.addAbility(ability);
    }

    private TelimTorsDarts(final TelimTorsDarts card) {
        super(card);
    }

    @Override
    public TelimTorsDarts copy() {
        return new TelimTorsDarts(this);
    }
}
