
package mage.cards.t;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.combat.MustBeBlockedByAllSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author Plopman
 */
public final class TauntingElf extends CardImpl {

    public TauntingElf(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{G}");
        this.subtype.add(SubType.ELF);

        this.power = new MageInt(0);
        this.toughness = new MageInt(1);

        // All creatures able to block Taunting Elf do so.
        this.addAbility(new SimpleStaticAbility(new MustBeBlockedByAllSourceEffect()));
    }

    private TauntingElf(final TauntingElf card) {
        super(card);
    }

    @Override
    public TauntingElf copy() {
        return new TauntingElf(this);
    }
}
