
package mage.cards.s;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.cost.SpellsCostReductionControllerEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.filter.FilterCard;

/**
 *
 * @author LevelX2
 */
public final class StoneCalendar extends CardImpl {

    public StoneCalendar(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT},"{5}");

        // Spells you cast cost up to {1} less to cast.
        this.addAbility(new SimpleStaticAbility(new SpellsCostReductionControllerEffect(new FilterCard("spells"), 1, true)));
        
    }

    private StoneCalendar(final StoneCalendar card) {
        super(card);
    }

    @Override
    public StoneCalendar copy() {
        return new StoneCalendar(this);
    }
}
