package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.RestrictionUntapNotMoreThanEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

/**
 *
 * @author Plopman
 */
public final class StoicAngel extends CardImpl {

    public StoicAngel(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{G}{W}{U}");
        this.subtype.add(SubType.ANGEL);

        this.power = new MageInt(3);
        this.toughness = new MageInt(4);

        // Flying
        this.addAbility(FlyingAbility.getInstance());
        // Vigilance
        this.addAbility(VigilanceAbility.getInstance());
        // Players can't untap more than one creature during their untap steps.
        this.addAbility(new SimpleStaticAbility(new StoicAngelEffect()));
    }

    private StoicAngel(final StoicAngel card) {
        super(card);
    }

    @Override
    public StoicAngel copy() {
        return new StoicAngel(this);
    }
}

class StoicAngelEffect extends RestrictionUntapNotMoreThanEffect {

    StoicAngelEffect() {
        super(Duration.WhileOnBattlefield, 1, StaticFilters.FILTER_CONTROLLED_CREATURE);
        staticText = "Players can't untap more than one creature during their untap steps";
    }

    private StoicAngelEffect(final StoicAngelEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Player player, Ability source, Game game) {
        // applied to all players
        return true;
    }

    @Override
    public StoicAngelEffect copy() {
        return new StoicAngelEffect(this);
    }

}
