
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.combat.CantBlockAttackActivateAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.target.TargetPermanent;
import mage.target.common.TargetArtifactPermanent;

/**
 *
 * @author Plopman
 */
public final class StasisCocoon extends CardImpl {

    public StasisCocoon(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{1}{W}");
        this.subtype.add(SubType.AURA);

        // Enchant artifact
        TargetPermanent auraTarget = new TargetArtifactPermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.Detriment));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);

        
        // Enchanted artifact can't attack or block, and its activated abilities can't be activated.
        Effect effect = new CantBlockAttackActivateAttachedEffect();
        effect.setText("Enchanted artifact can't attack or block, and its activated abilities can't be activated");
        this.addAbility(new SimpleStaticAbility(effect));
        
    }

    private StasisCocoon(final StasisCocoon card) {
        super(card);
    }

    @Override
    public StasisCocoon copy() {
        return new StasisCocoon(this);
    }
}
