
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SkipUntapOptionalAbility;
import mage.abilities.condition.common.SourceTappedCondition;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author LoneFox
 */
public final class SpiritShield extends CardImpl {

    public SpiritShield(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT},"{3}");

        // You may choose not to untap Spirit Shield during your untap step.
        this.addAbility(new SkipUntapOptionalAbility());
        // {2}, {tap}: Target creature gets +0/+2 for as long as Spirit Shield remains tapped.
        Ability ability = new SimpleActivatedAbility(new ConditionalContinuousEffect(
            new BoostTargetEffect(0, 2, Duration.Custom), SourceTappedCondition.TAPPED,
            "target creature gets +0/+2 for as long as {this} remains tapped"), new ManaCostsImpl<>("{2}"));
        ability.addCost(new TapSourceCost());
        ability.addTarget(new TargetCreaturePermanent());
        this.addAbility(ability);
    }

    private SpiritShield(final SpiritShield card) {
        super(card);
    }

    @Override
    public SpiritShield copy() {
        return new SpiritShield(this);
    }
}
