
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.RemoveCountersSourceCost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.permanent.token.SpawningPitToken;
import mage.target.common.TargetControlledCreaturePermanent;

/**
 *
 * @author Loki
 */
public final class SpawningPit extends CardImpl {

    public SpawningPit(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{2}");
        this.addAbility(new SimpleActivatedAbility(new AddCountersSourceEffect(CounterType.CHARGE.createInstance()),
                new SacrificeTargetCost(StaticFilters.FILTER_PERMANENT_CREATURE)));
        Ability ability = new SimpleActivatedAbility(new CreateTokenEffect(new SpawningPitToken()), new GenericManaCost(1));
        ability.addCost(new RemoveCountersSourceCost(CounterType.CHARGE.createInstance(2)));
        this.addAbility(ability);
    }

    private SpawningPit(final SpawningPit card) {
        super(card);
    }

    @Override
    public SpawningPit copy() {
        return new SpawningPit(this);
    }

}
