
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.MultipliedValue;
import mage.abilities.dynamicvalue.common.CardsInControllerHandCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author fireshoes
 */
public final class SophicCentaur extends CardImpl {

    public SophicCentaur(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{G}");
        this.subtype.add(SubType.CENTAUR);
        this.subtype.add(SubType.SPELLSHAPER);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // {2}{G}{G}, {tap}, Discard a card: You gain 2 life for each card in your hand.
        DynamicValue lifeToGainAmount = new MultipliedValue(CardsInControllerHandCount.instance, 2);
        Effect effect = new GainLifeEffect(lifeToGainAmount);
        effect.setText("You gain 2 life for each card in your hand");
        Ability ability = new SimpleActivatedAbility(effect, new ManaCostsImpl<>("{2}{G}{G}"));
        ability.addCost(new TapSourceCost());
        ability.addCost(new DiscardCardCost());
        this.addAbility(ability);
    }

    private SophicCentaur(final SophicCentaur card) {
        super(card);
    }

    @Override
    public SophicCentaur copy() {
        return new SophicCentaur(this);
    }
}
