
package mage.cards.s;

import java.util.UUID;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.effects.common.PreventDamageToControllerEffect;
import mage.abilities.effects.common.SacrificeSourceUnlessPaysEffect;
import mage.abilities.effects.common.SkipDrawStepEffect;
import mage.abilities.effects.common.continuous.GainAbilityControllerEffect;
import mage.abilities.keyword.ShroudAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.target.common.TargetCardInHand;

/**
 *
 * @author emerald000
 */
public final class SolitaryConfinement extends CardImpl {

    public SolitaryConfinement(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{2}{W}");

        // At the beginning of your upkeep, sacrifice Solitary Confinement unless you discard a card.
        this.addAbility(new BeginningOfUpkeepTriggeredAbility(new SacrificeSourceUnlessPaysEffect(new DiscardTargetCost(new TargetCardInHand()))));

        // Skip your draw step.
        this.addAbility(new SimpleStaticAbility(new SkipDrawStepEffect()));

        // You have shroud.
        this.addAbility(new SimpleStaticAbility(new GainAbilityControllerEffect(ShroudAbility.getInstance())));

        // Prevent all damage that would be dealt to you.
        this.addAbility(new SimpleStaticAbility(new PreventDamageToControllerEffect(Duration.WhileOnBattlefield)));
    }

    private SolitaryConfinement(final SolitaryConfinement card) {
        super(card);
    }

    @Override
    public SolitaryConfinement copy() {
        return new SolitaryConfinement(this);
    }
}
