
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.*;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.mageobject.AbilityPredicate;

/**
 *
 * @author LevelX2
 */
public final class SmogElemental extends CardImpl {

    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Creatures with flying your opponents control");
    static {
        filter.add(TargetController.OPPONENT.getControllerPredicate());
        filter.add(new AbilityPredicate(FlyingAbility.class));
    }

    public SmogElemental(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{4}{B}{B}");
        this.subtype.add(SubType.ELEMENTAL);

        this.power = new MageInt(3);
        this.toughness = new MageInt(3);

        // Flying
        this.addAbility(FlyingAbility.getInstance());

        // Creatures with flying your opponents control get -1/-1.
        this.addAbility(new SimpleStaticAbility(new BoostAllEffect(-1,-1, Duration.WhileOnBattlefield, filter, false)));
    }

    private SmogElemental(final SmogElemental card) {
        super(card);
    }

    @Override
    public SmogElemental copy() {
        return new SmogElemental(this);
    }
}
