package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.permanent.token.MetallicSliverToken;

/**
 *
 * @author Luna Skyrise
 */
public final class Sliversmith extends CardImpl {

    public Sliversmith(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}, "{2}");
        this.subtype.add(SubType.SPELLSHAPER);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // {1}, {T}, Discard a card: Create a 1/1 colorless Sliver artifact creature token named Metallic Sliver.
        Ability ability = new SimpleActivatedAbility(new CreateTokenEffect(new MetallicSliverToken()), new ManaCostsImpl<>("{1}"));
        ability.addCost(new TapSourceCost());
        ability.addCost(new DiscardCardCost());
        this.addAbility(ability);
    }

    private Sliversmith(final Sliversmith card) {
        super(card);
    }

    @Override
    public Sliversmith copy() {
        return new Sliversmith(this);
    }
}
