
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.condition.common.HateCondition;
import mage.abilities.decorator.ConditionalInterveningIfTriggeredAbility;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.target.TargetPlayer;
import mage.watchers.common.LifeLossOtherFromCombatWatcher;

/**
 *
 * @author Styxo
 */
public final class SithInquisitor extends CardImpl {

    public SithInquisitor(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{B}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.SITH);
        this.power = new MageInt(5);
        this.toughness = new MageInt(1);

        // <i>Hate</i> &mdash; When Sith Assassin enters the battlefield, if opponent lost life from source other than combat damage this turn, target player discard a card at random.
        Ability ability = new ConditionalInterveningIfTriggeredAbility(
                new EntersBattlefieldTriggeredAbility(new DiscardTargetEffect(1, true)),
                HateCondition.instance,
                "<i>Hate</i> &mdash; When {this} enters, if an opponent lost life from a source other then combat damage this turn, target player discard a card at random.");
        ability.addTarget(new TargetPlayer());
        this.addAbility(ability, new LifeLossOtherFromCombatWatcher());
    }

    private SithInquisitor(final SithInquisitor card) {
        super(card);
    }

    @Override
    public SithInquisitor copy() {
        return new SithInquisitor(this);
    }
}
