
package mage.cards.s;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.EquippedHasSubtypeCondition;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.keyword.EquipAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.target.common.TargetControlledCreaturePermanent;

/**
 * @author nantuko
 */
public final class SilverInlaidDagger extends CardImpl {

    private static final String staticText = "As long as equipped creature is a Human, it gets an additional +1/+0";

    public SilverInlaidDagger(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT},"{1}");
        this.subtype.add(SubType.EQUIPMENT);

        // Equipped creature gets +2/+0
        this.addAbility(new SimpleStaticAbility(new BoostEquippedEffect(2, 0)));

        // As long as equipped creature is a Human, it gets an additional +1/+0
        this.addAbility(new SimpleStaticAbility(new ConditionalContinuousEffect(new BoostEquippedEffect(1, 0), new EquippedHasSubtypeCondition(SubType.HUMAN), staticText)));

        // Equip {2}
        this.addAbility(new EquipAbility(Outcome.BoostCreature, new GenericManaCost(2), new TargetControlledCreaturePermanent(), false));
    }

    private SilverInlaidDagger(final SilverInlaidDagger card) {
        super(card);
    }

    @Override
    public SilverInlaidDagger copy() {
        return new SilverInlaidDagger(this);
    }
}
