package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.condition.common.RevoltCondition;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.effects.keyword.TheRingTemptsYouEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.watchers.common.RevoltWatcher;

import java.util.UUID;

/**
 * @author TheElk801
 */
public final class ShortcutToMushrooms extends CardImpl {

    public ShortcutToMushrooms(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{G}");

        // When Shortcut to Mushrooms enters the battlefield, the Ring tempts you.
        this.addAbility(new EntersBattlefieldTriggeredAbility(new TheRingTemptsYouEffect()));

        // At the beginning of your end step, if a permanent you controlled left the battlefield this turn, put a +1/+1 counter on target creature you control.
        Ability ability = new BeginningOfEndStepTriggeredAbility(
                TargetController.YOU, new AddCountersTargetEffect(CounterType.P1P1.createInstance()),
                false, RevoltCondition.instance
        ).addHint(RevoltCondition.getHint());
        ability.addTarget(new TargetControlledCreaturePermanent());
        this.addAbility(ability, new RevoltWatcher());
    }

    private ShortcutToMushrooms(final ShortcutToMushrooms card) {
        super(card);
    }

    @Override
    public ShortcutToMushrooms copy() {
        return new ShortcutToMushrooms(this);
    }
}
