
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.counter.GetEnergyCountersControllerEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author JRHerlehy
 */
public final class ShipwreckMoray extends CardImpl {

    public ShipwreckMoray(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{U}");
        
        this.subtype.add(SubType.FISH);
        this.power = new MageInt(0);
        this.toughness = new MageInt(5);

        // When Shipwreck Moray enters the battlefield, you get {E}{E}{E}{E}.
        this.addAbility(new EntersBattlefieldTriggeredAbility(new GetEnergyCountersControllerEffect(4)));

        // Pay {E}: Shipwreck Moray gets +2/-2 until end of turn.
        this.addAbility(new SimpleActivatedAbility(new BoostSourceEffect(2, -2, Duration.EndOfTurn), new PayEnergyCost(1)));
    }

    private ShipwreckMoray(final ShipwreckMoray card) {
        super(card);
    }

    @Override
    public ShipwreckMoray copy() {
        return new ShipwreckMoray(this);
    }
}
