
package mage.cards.s;

import java.util.UUID;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.filter.StaticFilters;
import mage.target.common.TargetControlledPermanent;
import mage.target.common.TargetAnyTarget;

/**
 *
 * @author Loki
 */
public final class ShardVolley extends CardImpl {

    public ShardVolley(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.INSTANT},"{R}");


        // As an additional cost to cast Shard Volley, sacrifice a land.
        this.getSpellAbility().addCost(new SacrificeTargetCost(StaticFilters.FILTER_LAND));

        // Shard Volley deals 3 damage to any target.
        this.getSpellAbility().addEffect(new DamageTargetEffect(3));
        this.getSpellAbility().addTarget(new TargetAnyTarget());
    }

    private ShardVolley(final ShardVolley card) {
        super(card);
    }

    @Override
    public ShardVolley copy() {
        return new ShardVolley(this);
    }
}
