package mage.cards.s;

import mage.abilities.TriggeredAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.abilities.condition.common.FatefulHourCondition;
import mage.abilities.decorator.ConditionalInterveningIfTriggeredAbility;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.abilities.effects.common.turn.AddExtraTurnControllerEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;

import java.util.UUID;

/**
 *
 * @author Plopman
 */
public final class SecondChance extends CardImpl {

    public SecondChance(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{2}{U}");

        // At the beginning of your upkeep, if you have 5 or less life, sacrifice Second Chance and take an extra turn after this one.
        TriggeredAbility ability  = new BeginningOfUpkeepTriggeredAbility(new SacrificeSourceEffect());
        ability.addEffect(new AddExtraTurnControllerEffect());
        this.addAbility(new ConditionalInterveningIfTriggeredAbility(ability, FatefulHourCondition.instance,
                "At the beginning of your upkeep, if you have 5 or less life, sacrifice {this} and take an extra turn after this one"));
    }

    private SecondChance(final SecondChance card) {
        super(card);
    }

    @Override
    public SecondChance copy() {
        return new SecondChance(this);
    }
    

}
