package mage.cards.s;

import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.ExileThenReturnTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicates;
import mage.target.TargetPermanent;

import java.util.UUID;

/**
 * @author TheElk801
 */
public final class Scrollshift extends CardImpl {

    private static final FilterPermanent filter = new FilterControlledPermanent("artifact, creature, or enchantment you control");

    static {
        filter.add(Predicates.or(
                CardType.ARTIFACT.getPredicate(),
                CardType.CREATURE.getPredicate(),
                CardType.ENCHANTMENT.getPredicate()
        ));
    }

    public Scrollshift(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{W}");

        // Exile up to one target artifact, creature, or enchantment you control, then return it to the battlefield under its owner's control.
        this.getSpellAbility().addEffect(new ExileThenReturnTargetEffect(false, false));
        this.getSpellAbility().addTarget(new TargetPermanent(0, 1, filter));

        // Draw a card.
        this.getSpellAbility().addEffect(new DrawCardSourceControllerEffect(1).concatBy("<br>"));
    }

    private Scrollshift(final Scrollshift card) {
        super(card);
    }

    @Override
    public Scrollshift copy() {
        return new Scrollshift(this);
    }
}
