
package mage.cards.s;

import java.util.UUID;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.PreventDamageToTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author L_J
 */
public final class SamiteSanctuary extends CardImpl {

    public SamiteSanctuary(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{W}");

        // {2}: Prevent the next 1 damage that would be dealt to target creature this turn. Any player may activate this ability.
        SimpleActivatedAbility ability = new SimpleActivatedAbility(new PreventDamageToTargetEffect(Duration.EndOfTurn ,1), new ManaCostsImpl<>("{2}"));
        ability.addTarget(new TargetCreaturePermanent());
        ability.setMayActivate(TargetController.ANY);
        ability.addEffect(new InfoEffect("Any player may activate this ability"));
        this.addAbility(ability);
    }

    private SamiteSanctuary(final SamiteSanctuary card) {
        super(card);
    }

    @Override
    public SamiteSanctuary copy() {
        return new SamiteSanctuary(this);
    }
}
