package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EquipAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.*;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetControlledCreaturePermanent;

/**
 * @author nantuko
 */
public final class RunechantersPike extends CardImpl {

    protected static final FilterCard filterCard = new FilterCard();

    static {
        filterCard.add(Predicates.or(
                CardType.INSTANT.getPredicate(),
                CardType.SORCERY.getPredicate()));
    }

    public RunechantersPike(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{2}");
        this.subtype.add(SubType.EQUIPMENT);

        // Equipped creature has first strike and gets +X/+0 where X is the number of instant and sorcery cards in your graveyard.
        Effect effect = new GainAbilityAttachedEffect(FirstStrikeAbility.getInstance(), AttachmentType.EQUIPMENT);
        Effect effect2 = new BoostEquippedEffect(new RunechantersPikeValue(), StaticValue.get(0));
        effect.setText("Equipped creature has first strike");
        effect2.setText(" and gets +X/+0 where X is the number of instant and sorcery cards in your graveyard.");
        Ability ability = new SimpleStaticAbility(effect);
        ability.addEffect(effect2);
        this.addAbility(ability);

        // Equip {2}
        this.addAbility(new EquipAbility(Outcome.BoostCreature, new GenericManaCost(2), new TargetControlledCreaturePermanent(), false));
    }

    private RunechantersPike(final RunechantersPike card) {
        super(card);
    }

    @Override
    public RunechantersPike copy() {
        return new RunechantersPike(this);
    }
}

class RunechantersPikeValue implements DynamicValue {

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player player = game.getPlayer(sourceAbility.getControllerId());
        if (player != null) {
            return player.getGraveyard().getCards(RunechantersPike.filterCard, game).size();
        }
        return 0;
    }

    @Override
    public DynamicValue copy() {
        return this;
    }

    @Override
    public String getMessage() {
        return "instant and sorcery card in your graveyard";
    }

    @Override
    public String toString() {
        return "X";
    }
}
