package mage.cards.r;

import mage.MageInt;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.abilities.condition.common.DescendedThisTurnCondition;
import mage.abilities.dynamicvalue.common.DescendedThisTurnCount;
import mage.abilities.effects.keyword.ScryEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.watchers.common.DescendedWatcher;

import java.util.UUID;

/**
 * @author TheElk801
 */
public final class RuinLurkerBat extends CardImpl {

    public RuinLurkerBat(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{W}");

        this.subtype.add(SubType.BAT);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Flying
        this.addAbility(FlyingAbility.getInstance());

        // Lifelink
        this.addAbility(LifelinkAbility.getInstance());

        // At the beginning of your end step, if you descended this turn, scry 1.
        this.addAbility(new BeginningOfEndStepTriggeredAbility(
                TargetController.YOU, new ScryEffect(1, false),
                false, DescendedThisTurnCondition.instance
        ).addHint(DescendedThisTurnCount.getHint()), new DescendedWatcher());
    }

    private RuinLurkerBat(final RuinLurkerBat card) {
        super(card);
    }

    @Override
    public RuinLurkerBat copy() {
        return new RuinLurkerBat(this);
    }
}
