
package mage.cards.r;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.common.RegenerateSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.target.common.TargetControlledPermanent;

/**
 *
 * @author LoneFox
 */
public final class RootwaterAlligator extends CardImpl {

    private static final FilterControlledPermanent filter = new FilterControlledPermanent("a Forest");

    static{
        filter.add(SubType.FOREST.getPredicate());
    }

    public RootwaterAlligator(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{G}");
        this.subtype.add(SubType.CROCODILE);
        this.power = new MageInt(3);
        this.toughness = new MageInt(2);

        // Sacrifice a Forest: Regenerate Rootwater Alligator.
        this.addAbility(new SimpleActivatedAbility(new RegenerateSourceEffect(), new SacrificeTargetCost(filter)));
    }

    private RootwaterAlligator(final RootwaterAlligator card) {
        super(card);
    }

    @Override
    public RootwaterAlligator copy() {
        return new RootwaterAlligator(this);
    }
}
