
package mage.cards.r;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.MountainwalkAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author fireshoes
 */
public final class RiverMerfolk extends CardImpl {

    public RiverMerfolk(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{U}{U}");
        this.subtype.add(SubType.MERFOLK);
        this.power = new MageInt(2);
        this.toughness = new MageInt(1);

        // {U}: River Merfolk gains mountainwalk until end of turn.
        this.addAbility(new SimpleActivatedAbility(
                new GainAbilitySourceEffect(new MountainwalkAbility(false), Duration.EndOfTurn),
                new ManaCostsImpl<>("{U}")));
    }

    private RiverMerfolk(final RiverMerfolk card) {
        super(card);
    }

    @Override
    public RiverMerfolk copy() {
        return new RiverMerfolk(this);
    }
}
