
package mage.cards.r;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.common.continuous.GainProtectionFromColorSourceEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author cbt33, BetaSteward (GainProtectionFromColorTargetEffect)
 */
public final class ResilientWanderer extends CardImpl {

    public ResilientWanderer(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{W}{W}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.NOMAD);

        this.power = new MageInt(2);
        this.toughness = new MageInt(3);

        // First strike
        this.addAbility(FirstStrikeAbility.getInstance());
        // Discard a card: Resilient Wanderer gains protection from the color of your choice until end of turn.
        Ability ability = new SimpleActivatedAbility(new GainProtectionFromColorSourceEffect(Duration.EndOfTurn), new DiscardCardCost());
        this.addAbility(ability);
    }

    private ResilientWanderer(final ResilientWanderer card) {
        super(card);
    }

    @Override
    public ResilientWanderer copy() {
        return new ResilientWanderer(this);
    }
}
