
package mage.cards.r;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.GainProtectionFromColorSourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author LoneFox
 */
public final class RappellingScouts extends CardImpl {

    public RappellingScouts(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{W}{W}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.REBEL);
        this.subtype.add(SubType.SCOUT);
        this.power = new MageInt(1);
        this.toughness = new MageInt(4);

        // Flying
        this.addAbility(FlyingAbility.getInstance());
        // {2}{W}: Rappelling Scouts gains protection from the color of your choice until end of turn.
        this.addAbility(new SimpleActivatedAbility(new GainProtectionFromColorSourceEffect(Duration.EndOfTurn), new ManaCostsImpl<>("{2}{W}")));
    }

    private RappellingScouts(final RappellingScouts card) {
        super(card);
    }

    @Override
    public RappellingScouts copy() {
        return new RappellingScouts(this);
    }
}
