
package mage.cards.r;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.BecomesColorSourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author LoneFox

 */
public final class RainbowCrow extends CardImpl {

    public RainbowCrow(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{U}");
        this.subtype.add(SubType.BIRD);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // Flying
        this.addAbility(FlyingAbility.getInstance());
        //
        // {1}: Rainbow Crow becomes the color of your choice until end of turn.
        this.addAbility(new SimpleActivatedAbility(new BecomesColorSourceEffect(Duration.EndOfTurn), new ManaCostsImpl<>("{1}")));
    }

    private RainbowCrow(final RainbowCrow card) {
        super(card);
    }

    @Override
    public RainbowCrow copy() {
        return new RainbowCrow(this);
    }
}
