
package mage.cards.r;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.cost.SpellsCostReductionControllerEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;

/**
 *
 * @author LevelX2
 */
public final class Ragemonger extends CardImpl {

    private static final FilterCard filter = new FilterCard("Minotaur spells");
    static {
        filter.add(SubType.MINOTAUR.getPredicate());
    }

    public Ragemonger(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{B}{R}");
        this.subtype.add(SubType.MINOTAUR);
        this.subtype.add(SubType.SHAMAN);

        this.power = new MageInt(2);
        this.toughness = new MageInt(3);

        // Minotaur spells you cast cost {B}{R} less to cast. This effect reduces only the amount of colored mana you pay.
        this.addAbility(new SimpleStaticAbility(new SpellsCostReductionControllerEffect(filter, new ManaCostsImpl<>("{B}{R}"))));
    }

    private Ragemonger(final Ragemonger card) {
        super(card);
    }

    @Override
    public Ragemonger copy() {
        return new Ragemonger(this);
    }
}
