
package mage.cards.q;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author fireshoes
 */
public final class QuilledWolf extends CardImpl {

    public QuilledWolf(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{G}");
        this.subtype.add(SubType.WOLF);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // {5}{G}: Quilled Wolf gets +4/+4 until end of turn.
        this.addAbility(new SimpleActivatedAbility(new BoostSourceEffect(4, 4, Duration.EndOfTurn), new ManaCostsImpl<>("{5}{G}")));
    }

    private QuilledWolf(final QuilledWolf card) {
        super(card);
    }

    @Override
    public QuilledWolf copy() {
        return new QuilledWolf(this);
    }
}
