
package mage.cards.q;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;
import mage.target.common.TargetPlayerOrPlaneswalker;

/**
 *
 * @author Plopman
 */
public final class QuicksilverDagger extends CardImpl {

    public QuicksilverDagger(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{U}{R}");
        this.subtype.add(SubType.AURA);

        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.AddAbility));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);

        // Enchanted creature has "{tap}: This creature deals 1 damage to target player. You draw a card."
        Ability gainAbility = new SimpleActivatedAbility(new DamageTargetEffect(1), new TapSourceCost());
        gainAbility.addTarget(new TargetPlayerOrPlaneswalker());
        gainAbility.addEffect(new DrawCardSourceControllerEffect(1));
        this.addAbility(new SimpleStaticAbility(
                new GainAbilityAttachedEffect(gainAbility, AttachmentType.AURA, Duration.WhileOnBattlefield,
                        "Enchanted creature has \"{T}: This creature deals 1 damage to target player or planeswalker. You draw a card.\"")
        ));
    }

    private QuicksilverDagger(final QuicksilverDagger card) {
        super(card);
    }

    @Override
    public QuicksilverDagger copy() {
        return new QuicksilverDagger(this);
    }
}
