package mage.cards.p;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.RemoveCountersSourceCost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.common.FilterControlledPermanent;
import mage.game.permanent.token.SaprolingToken;

/**
 *
 * @author fireshoes
 */
public final class PsychotropeThallid extends CardImpl {

    private static final FilterControlledPermanent filter = new FilterControlledPermanent(SubType.SAPROLING, "a Saproling");

    public PsychotropeThallid(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{G}");
        this.subtype.add(SubType.FUNGUS);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // At the beginning of your upkeep, put a spore counter on Psychotrope Thallid.
        this.addAbility(new BeginningOfUpkeepTriggeredAbility(new AddCountersSourceEffect(CounterType.SPORE.createInstance())));
        // Remove three spore counters from Psychotrope Thallid: Create a 1/1 green Saproling creature token.
        this.addAbility(new SimpleActivatedAbility(
                new CreateTokenEffect(new SaprolingToken()),
                new RemoveCountersSourceCost(CounterType.SPORE.createInstance(3))));
        // {1}, Sacrifice a Saproling: Draw a card.
        Ability ability = new SimpleActivatedAbility(
                new DrawCardSourceControllerEffect(1),
                new SacrificeTargetCost(filter));
        ability.addCost(new GenericManaCost(1));
        this.addAbility(ability);
    }

    private PsychotropeThallid(final PsychotropeThallid card) {
        super(card);
    }

    @Override
    public PsychotropeThallid copy() {
        return new PsychotropeThallid(this);
    }
}
