
package mage.cards.p;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.combat.CantBeBlockedSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author Plopman
 */
public final class PlasmaElemental extends CardImpl {

    public PlasmaElemental(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{5}{U}");
        this.subtype.add(SubType.ELEMENTAL);

        this.power = new MageInt(4);
        this.toughness = new MageInt(1);

        // Plasma Elemental can't be blocked.
        this.addAbility(new SimpleStaticAbility(new CantBeBlockedSourceEffect()));
    }

    private PlasmaElemental(final PlasmaElemental card) {
        super(card);
    }

    @Override
    public PlasmaElemental copy() {
        return new PlasmaElemental(this);
    }
}
