
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.abilities.effects.common.combat.CantAttackBlockAttachedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

/**
 * @author mluds
 */
public final class PilloryOfTheSleepless extends CardImpl {

    public PilloryOfTheSleepless(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{1}{W}{B}");
        this.subtype.add(SubType.AURA);


        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.Removal));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);
	
        // Enchanted creature can't attack or block.
        this.addAbility(new SimpleStaticAbility(new CantAttackBlockAttachedEffect(AttachmentType.AURA)));
	
        // Enchanted creature has "At the beginning of your upkeep, you lose 1 life."
        this.addAbility(new SimpleStaticAbility(new GainAbilityAttachedEffect(
                new BeginningOfUpkeepTriggeredAbility(new LoseLifeSourceControllerEffect(1)), AttachmentType.AURA)));
    }

    private PilloryOfTheSleepless(final PilloryOfTheSleepless card) {
        super(card);
    }

    @Override
    public PilloryOfTheSleepless copy() {
        return new PilloryOfTheSleepless(this);
    }
}
