
package mage.cards.p;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author Plopman
 */
public final class PatagiaGolem extends CardImpl {

    public PatagiaGolem(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT,CardType.CREATURE},"{4}");
        this.subtype.add(SubType.GOLEM);

        this.power = new MageInt(2);
        this.toughness = new MageInt(3);

        // {3}: Patagia Golem gains flying until end of turn.
        Ability ability = new SimpleActivatedAbility(new GainAbilitySourceEffect(FlyingAbility.getInstance(), Duration.EndOfTurn), new ManaCostsImpl<>("{3}"));
        this.addAbility(ability);
        
    }

    private PatagiaGolem(final PatagiaGolem card) {
        super(card);
    }

    @Override
    public PatagiaGolem copy() {
        return new PatagiaGolem(this);
    }
}
